/* 修改时间2016-11-12 by chchange
    TM1637(uint8_t pinClk, uint8_t pinDIO);
  //!初始化一个TM1637对象，设置时钟和数据引脚。
  //!@参数 pinclk -数字引脚连接到模块的时钟引脚数
  //!@参数 pindio -数字引脚连接到模块的DIO引脚数
  --------------------------------------------------------------------------------------------------
   void BL(uint8_t brightness);
  // 设置显示的亮度。
  // @param brightness -从0-7级亮度,运行默认为3级亮度
 --------------------------------------------------------------------------------------------------
   void setSegments(const uint8_t segments[], uint8_t length = 4, uint8_t pos = 0);
  //!在模块上显示任意数据
  //!此功能接收原始段值作为输入，并显示它们。数据段作为一个字节数组,每个字节对应一个数字。在每个字节0维是段A，1维是段B等。 
  //!@param segments 显示的4维数组
  //! @param length 设置显示的数字的数量。用户必须确保显示的数字符合要求的数字（例如，如果两个数字被显示，数字必须在0到99之间,大于99则只显示个位与十位两位)
  //! @param pos 第一个数字位置 0-3，0最左，3最右（例如，123这个数，Pos=0,1显示在最在边；POS=1，1显示在左边第二个；POS=3，1显示在第四位）//
   --------------------------------------------------------------------------------------------------
   void Num(int num, bool leading_zero = false, uint8_t length = 4, uint8_t pos = 0);
  //! 显示十进制数字
  //! @param leading_zero 为真是，前面的填充0
  //! @param length 设置显示的数字的数量。用户必须确保显示的数字符合要求的数字（例如，如果两个数字被显示，数字必须在0到99之间,大于99则只显示个位与十位两位)
  //! @param pos 第一个数字位置 0-3，0最左，3最右（例如，123这个数，Pos=0,1显示在最在边；POS=1，1显示在左边第二个；POS=3，1显示在第四位）
   --------------------------------------------------------------------------------------------------
  uint8_t encodeDigit(uint8_t digit);
  //! 将一个数字转换成7段代码!
  //! 该方法在0 - 15之间接受一个数字，并将其转换为显示在7段显示上的数字所需的代码。 数字之间10-15转换为十六进制数字（A-F）!
  //! @param digit 数字0-15
  //! @return 返回代码表示数字7段图像（LSB段；位6段G；7位总为零）
 --------------------------------------------------------------------------------------------------
  void DNum(uint8_t num1,uint8_t num2,bool piont =true);
 //! 显示两组数字
 //! @param num1 0-99，大于99点显示十位及个位,显示在左边两位
 //! @param num2 0-99，大于99点显示十位及个位,显示在右边两位
 //! @param piont 是否显示中间两点
 --------------------------------------------------------------------------------------------------
   void show(bool BS);
  //!是否显示
//! @param BS 为真显示，否则不显示
 --------------------------------------------------------------------------------------------------
void cls();
 清除所有显示的数据
*/
#include <TM1637.h>

// 配置引脚
#define CLK 4
#define DIO 3

//延时时间
#define TEST_DELAY   2000

TM1637 TM(CLK, DIO);

void setup()
{

}

void loop()
{
  int k=123;
  bool ZD;
  TM.cls();//清除
  //显示1位数，位置从第0位到每3位
  for(int i=0; i<4;i++)
{
  TM.Num(i,0,1,i);//显示i，不填充0,显示1位，显示在每i位
  delay(TEST_DELAY);
  }
  
  for(int i=0; i<8;i++)
{
  TM.Num(i,1);
  TM.BL(i);//调节亮度
  delay(TEST_DELAY);
  }

  TM.Num(k,0);//不填充
  delay(TEST_DELAY);
  TM.Num(k,1);//填充
  delay(TEST_DELAY);

//显示与隐藏
   for(int i=0; i<4;i++)
{
   TM.show(false);
   delay(TEST_DELAY/2);
   TM.show(true);
   delay(TEST_DELAY/2);   
}
//显示双组数
   for(int i=0; i<20;i++)
{
  ZD=!ZD;
 TM.DNum(i/2,i/2,ZD);
 delay(500);
}

delay(5000);
  
}

